/**
* \file: NaviStatusImpl.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: Ajay Kumar Sahoo / RBEI/ECF3 / ajaykumar.sahoo@in.bosch.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include "NaviStatusImpl.h"

LOG_IMPORT_CONTEXT(navi_status)

namespace adit { namespace aauto {

NaviStatusImpl::NaviStatusImpl(NavigationStatusEndpoint* inEndpoint, void* inSessionContext)
{
    mEndpoint = inEndpoint;
    mSessionContext = inSessionContext;
    mCallbacks = nullptr;
}
NaviStatusImpl::~NaviStatusImpl()
{
    shutdown();
}
void NaviStatusImpl::setConfigItem(std::string inKey, std::string inValue)
{
    // empty implementation
    (void) inKey;
    (void) inValue;
}

void NaviStatusImpl::registerCallbacks(IAditNavigationStatusCallbacks* inCallbacks)
{
    //register application callbacks with this endpoint.
    //google receiver triggers this endpoint callbacks
    //and this endpoint callbacks inturn call application callbacks.
    mCallbacks = inCallbacks;
}
bool NaviStatusImpl::init()
{
    //register Navigation callbacks of this endpoint with Google receiver
    mEndpoint->registerCallbacks(this);
    return true;
}

void NaviStatusImpl::shutdown()
{
    LOGD_DEBUG((navi_status, "%s() shut down", __FUNCTION__));
    // nothing to do
}

// callback functions
void NaviStatusImpl::navigationStatusCallback(int status)
{
    //call application callback
    mCallbacks->navigationStatusCallback(status);
}

void NaviStatusImpl::navigationNextTurnCallback(const std::string &road, int turnSide, int event, const std::string &image, int turnAngle, int turnNumber)
{
    //call application callback
    mCallbacks->navigationNextTurnCallback(road, turnSide, event, image, turnAngle, turnNumber);
}

void NaviStatusImpl::navigationNextTurnDistanceCallback(int distanceMeters, int timeSeconds, int displayDistanceE3,
                                                        NavigationNextTurnDistanceEvent_DistanceUnits displayDistanceUnit)
{
    //call application callback
    mCallbacks->navigationNextTurnDistanceCallback(distanceMeters, timeSeconds, displayDistanceE3, displayDistanceUnit);
}

} } // namespace adit { namespace aauto {
